; cpu_avx.asm
extern printf
section .data							
	fmt_noavx 	db 	"Ten procesor nie obsługuje AVX.",10,0
	fmt_avx 		db 	"Ten procesor obsługuje AVX.",10,0
	fmt_noavx2 	db 	"Ten procesor nie obsługuje AVX2.",10,0        
	fmt_avx2 		db 	"Ten procesor obsługuje AVX2.",10,0     
	fmt_noavx512 	db 	"Ten procesor nie obsługuje AVX-512.",10,0        
	fmt_avx512 	db 	"Ten procesor obsługuje AVX-512.",10,0     
section .bss
section .text							
	global main					
main:
push	rbp
mov	rbp,rsp
	call	cpu_sse    	; zwraca 1 w rax, jeśli procesor obsługuje AVX, w przeciwnym razie 0  
leave
ret

cpu_sse:
push	rbp
mov	rbp,rsp
; testujemy pod kątem avx
    	mov 		eax,1        	; badamy flagi funkcji procesora
    	cpuid                   
    	mov 		eax,28   		; testujemy bit 28 w ecx
    	bt 		ecx,eax
    	jnc 		no_avx
    	xor 		rax,rax
    	mov 		rdi,fmt_avx
    	call 	printf
; testujemy pod kątem avx2
    	mov 		eax,7         	; badamy flagi funkcji procesora
    	mov 		ecx,0
    	cpuid                   
    	mov 		eax,5      	; testujemy bit 5 w ebx
    	bt 		ebx,eax
    	jnc 		the_exit
    	xor 		rax,rax
    	mov 		rdi,fmt_avx2
    	call 	printf
; testujemy pod kątem avx512
    	mov 		eax,7        	; badamy flagi funkcji procesora
    	mov 		ecx,0
    	cpuid                   
    	mov 		eax,16       	; testujemy bit 16 w ebx
    	bt 		ebx,eax
    	jnc 		no_avx512
    	xor 		rax,rax
    	mov 		rdi,fmt_avx512
    	call 	printf
    	jmp 		the_exit
no_avx:
    	mov 		rdi,fmt_noavx
    	xor 		rax,rax
    	call 	printf       	; wyświetlamy komunikat, jeśli AVX jest niedostępne
    	xor 		rax,rax     	; zwracamy 0, brak AVX
    	jmp 		the_exit     	; i kończymy działanie

no_avx2:  
    	mov 		rdi,fmt_noavx2
    	xor 		rax,rax
    	call 	printf       	; wyświetlamy komunikat, jeśli AVX jest niedostępne
    	xor 		rax,rax      	; zwracamy 0, brak AVX
    	jmp 		the_exit     	; i kończymy działanie 

no_avx512:  
    	mov 		rdi,fmt_noavx512
    	xor 		rax,rax
    	call 	printf       	;wyświetlamy komunikat, jeśli AVX jest niedostępne
    	xor 		rax,rax    	; zwracamy 0, brak AVX
    	jmp 		the_exit      	; i kończymy działanie  

the_exit:      
leave
ret
